import java.io.*;
import java.util.*;
import java.math.*;

public class E implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	private boolean solveOne() throws IOException {
		int n = nextInt();
		if (n == 0)
			return false;
		int[] xs = new int[n], rs = new int[n];
		for (int i = 0; i < n; i++) {
			xs[i] = nextInt();
			rs[i] = nextInt();
		}
		double l = 0.0, r = 1e6;
		for (int it = 0; it < 60; it++) {
			double m = (l + r) / 2.0;
			if (check(n, xs, rs, m)) {
				l = m;
			} else {
				r = m;
			}
		}
		double result = (l + r) * 0.5;
		out.println(result);
		return true;
	}

	class Event implements Comparable<Event> {
		double x;
		boolean type;

		public Event(double x, boolean type) {
			this.x = x;
			this.type = type;
		}

		public int compareTo(Event other) {
			return Double.compare(x, other.x);
		}
	}

	private boolean check(int n, int[] xs, int[] rs, double y) {
		y *= 0.5;
		List<Event> events = new ArrayList<Event>();
		for (int i = 0; i < n; i++) {
			if (rs[i] > y) {
				double tmp = Math.sqrt((double) rs[i] * rs[i] - y * y);
				double x0 = xs[i] - tmp;
				double x1 = xs[i] + tmp;
				events.add(new Event(x0, true));
				events.add(new Event(x1, false));
			}
		}
		Collections.sort(events);
		double x = 0.0;
		int level = 0;
		for (Event e : events) {
			if (e.type) {
				if (level == 0) {
					x = e.x;
				}
				++level;
			} else {
				--level;
				if (level == 0) {
					double dx = e.x - x;
					if (dx >= 2 * y) {
						return true;
					}
				}
			}
		}
		return false;
	}

	private void solve() throws IOException {
		while (solveOne())
			;
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new E().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
